setwd("<your directory or folder path>")
df1 <- read.csv("20171115 Example 3.1 With and Without Error Control.csv")
#library(car) #needed to use function Anova() - not the same as anova()
library(lmerTest)
# Variables
# 
# Unit
# Group
# Order
# Treatment
# Response
attach(df1)

fGroup <- factor(Group)
fUnit <- factor(Unit)
fOrder <- factor(Order)
#
# fUnit is nested in Group
# There are two ways to represent this in the model statement:
# fGroup/fUnit
# fUnit%in%fGroup
#
# fGroup/fUnit = fGroup + fUnit%in%fGroup
#
#  Note the different order in which factors are listed in these two specifications
#

model_with <- lm(Response ~ fGroup + fUnit%in%fGroup + fOrder + factor(Treatment))
model_without <- lm(Response ~ factor(Treatment))
model_mixed <- lmer(Response ~ factor(Treatment) + fOrder + fGroup +(1|fGroup:fUnit))
#
# alternative specification:
#model_mixed <- lmer(Response ~ factor(Treatment) + fOrder +(1|fGroup/fUnit))
# In this specification, fGroup is treated as random
#
anova(model_with)
anova(model_without)
anova(model_mixed)
#Anova(model_mixed,test.statistic="F",type=2)

#
#
#


